#ifndef CGEN2TAGENGINEERINGDIALOG_H
#define CGEN2TAGENGINEERINGDIALOG_H

#include <QDialog>
#include <ui_CGen2TagEngineeringDialog.h>
#include "../../ui/ConfigDialog.h"

class TagTabWidget;

class QrfeReaderInterface;
class QrfeGen2Tag;

class CGen2TagEngineeringDialog : public QDialog, ConfigDialog
{
    Q_OBJECT

public:
    CGen2TagEngineeringDialog(QWidget *parent = 0);
    ~CGen2TagEngineeringDialog();

private:
    int execPrivate ( );
public slots:
	int exec ( QrfeReaderInterface* ph, QString tagId, uint antennaId );
	virtual void done(int r);

private slots:
	void tabWidgetWorking();
	void tabWidgetIdle();

	void currentTabChanged( int index );

	void permissionsChanged();

protected:
	virtual void closeEvent ( QCloseEvent * event );

private:
	void addTabWidget(TagTabWidget* widget);

	void reloadExecutionCount(int tabIndex);

private:
	QrfeReaderInterface* 			m_reader;
	QrfeGen2Tag*					m_tag;
	uint 							m_antennaId;

	ushort 							m_originalAttenuation;
	uchar 							m_originalFrequencyMode;
	QList<uint>						m_originalFrequency;
	QList<QPair<uchar,ulong> > 		m_originalSequence;

	bool							m_loaded;

	QList<TagTabWidget*>			m_tabWidgets;

    Ui::CGen2TagEngineeringDialogClass ui;
};

#endif // CGEN2TAGENGINEERINGDIALOG_H
